<?php
// public_html/px/offersadd/test_form.php

require_once __DIR__ . '/px_client.php';

$response = null;
$callerId = '';
$zip      = '';
$vertical = 'roofing';
$subId    = 'GG1';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $callerId = $_POST['caller_id'] ?? '';
    $zip      = $_POST['zip'] ?? '';
    $vertical = $_POST['vertical'] ?? 'roofing';
    $subId    = $_POST['subid'] ?? 'GG1';

    // Map dropdown to campaign key used in config.php
    switch ($vertical) {
        case 'windows':
            $campaignKey = 'windows';
            break;
        case 'bathroom':
            $campaignKey = 'bathroom';
            break;
        case 'roofing':
        default:
            $campaignKey = 'roofing';
            break;
    }

    $response = px_ping($campaignKey, $callerId, $zip, $subId);
}

?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>PX Ping/Post Test Panel</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        label { display: block; margin-top: 10px; }
        input, select { padding: 4px; width: 260px; }
        button { margin-top: 15px; padding: 6px 14px; cursor: pointer; }
        pre { background: #f4f4f4; padding: 10px; white-space: pre-wrap; }
    </style>
</head>
<body>
    <h2>PX Ping/Post Test Panel</h2>

    <form method="post">
        <label>
            Caller ID:
            <input type="text" name="caller_id" value="<?php echo htmlspecialchars($callerId ?: '15556667777'); ?>">
        </label>

        <label>
            ZIP Code:
            <input type="text" name="zip" value="<?php echo htmlspecialchars($zip ?: '90100'); ?>">
        </label>

        <label>
            Vertical:
            <select name="vertical">
                <option value="roofing"  <?php echo $vertical === 'roofing'  ? 'selected' : ''; ?>>Roofing</option>
                <option value="windows"  <?php echo $vertical === 'windows'  ? 'selected' : ''; ?>>Windows</option>
                <option value="bathroom" <?php echo $vertical === 'bathroom' ? 'selected' : ''; ?>>Bathroom Remodeling</option>
            </select>
        </label>

        <label>
            SubID:
            <input type="text" name="subid" value="<?php echo htmlspecialchars($subId); ?>">
        </label>

        <button type="submit">RUN TEST</button>
    </form>

    <?php if ($response !== null): ?>
        <h3>Response:</h3>
        <pre>
HTTP Code: <?php echo $response['px_http_code']; ?>

Curl Error: <?php echo $response['px_curl_error']; ?>


<?php echo json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES); ?>

        </pre>
    <?php endif; ?>
</body>
</html>
